# [eBeB
module Event_Compiler_Util
  module_function

  # Autiof[^쐬
  def create_audio_object(value)
    values = value.split(/,|A/)
    audio= RPG::AudioFile.new()
    audio.name = values[0].to_s.toutf8 if values.size >= 1
    audio.volume = values[1].to_i if values.size >= 2
    audio.pitch = values[2].to_i if values.size >= 3
    return audio
  end
  def create_audio_parameter(audio)
    return [audio.name.tosjis,audio.volume,audio.pitch]
  end

  # @̃p[X
  BLEND_TYPES = ['ʏ','Z','Z']

  def blend_type(_value)
    value = _value.strip
    id = nil
    if value =~ /^[0-2]$/
    id = value.to_i
    elsif BLEND_TYPES.include? value.tosjis
    id = BLEND_TYPES.index(value.tosjis)
    end
    if id.nil?
      # TODO G[
      Log.error("parse_blend_type:" + value)
    id = 0
    end
    return id
  end
  def blend_type_name(i)
    BLEND_TYPES[i]
  end

  # ̃p[X
  DIRECTION_TYPES = {''=>2,''=>4,'E'=>6,''=>8}
  DIRECTION_NAMES = DIRECTION_TYPES.invert

  def parse_direction(value)
    direction = 2
    if value =~ /^[2468]$/
    direction = value.to_i
    elsif DIRECTION_TYPES.include? value.tosjis
    direction = DIRECTION_TYPES[value.tosjis]
    else
    direction = 0
    end
    return direction
  end
  def direction(value)
    parse_direction(value)
  end
  def direction_name(value)
    if DIRECTION_NAMES.include? value
      return DIRECTION_NAMES[value]
    else
      return DIRECTION_NAMES[2]
    end
  end

  # {^̃p[X
  BUTTON_TYPES = {
    '' => Input::DOWN,
    '' => Input::LEFT,
    'E' => Input::RIGHT,
    '' => Input::UP,
    'DOWN' => Input::DOWN,
    'LEFT' => Input::LEFT,
    'RIGHT' => Input::RIGHT,
    'UP' => Input::UP,
    'A' => Input::A,
    'B' => Input::B,
    'C' => Input::C,
    'X' => Input::X,
    'Y' => Input::Y,
    'Z' => Input::Z,
    'L' => Input::L,
    'R' => Input::R,
    'SHIFT' => Input::SHIFT,
    'CTRL'  => Input::CTRL,
    'ALT'   => Input::ALT,
    'F5' => Input::F5,
    'F6' => Input::F6,
    'F7' => Input::F7,
    'F8' => Input::F8,
    'F9' => Input::F9,
  }
  BUTTON_NAMES = BUTTON_TYPES.invert

  # {^
  def parse_button_id(value)
    if not BUTTON_TYPES.member?(value)
      return 2
    end
    return BUTTON_TYPES[value]
  end
  def button_id(value)
    return parse_button_id(value)
  end
  def button_name(value)
    if not BUTTON_NAMES.member?(value)
      return ''
    end
    return BUTTON_NAMES[value]
  end

  # XCb`
  def switch_name(id)
    return Data_Loader.data_system.switches[id].tosjis
  end
  def switch_id(value)
    return parse_switch_id(value)
  end

  # XCb`̃p[X
  def parse_switch_id(value)
    id = nil
    if value =~ /\[(.+?)\]/
    id = Switches.index($1.strip)
    end
    if id.nil?
    id = Switches.index(value.strip)
    end
    if id.nil? and value =~ /^[0-9]+$/
    id = value.to_i
    end
    if id.nil?
      # TODO G[
      Log.error("XCb`hc擾G[F#{value}")
    end
    return id
  end

  # XCb`l̃p[X
  def parse_switch_value(value)
    if value =~ /ON/
      return 0
    end
    return 1
  end
  def switch_value_string(value)
    case value
    when 0
      return 'ON'
    when 1
      return 'OFF'
    end
    return 'ON'
  end
  
  def variable_name(id)
    return Data_Loader.data_system.variables[id].tosjis
  end
  def variable_id(value)
    return parse_variable_id(value)
  end

  # ϐ̃p[X
  def parse_variable_id(value)
    id = nil
    if value =~ /^[0-9]+$/
      id = value.to_i
    end
    if value =~ /\[(.+?)\]/
      id = Variables.index($1.strip.toutf8)
    end
    if id.nil?
      id = Variables.index(value.strip.toutf8)
    end
    if id.nil? or id < 0
      # TODO G[
      Log.error("ϐhc擾G[F#{value}")
    end
    return id
  end

  # name \bhIuWFNgIDIuWFNgXg猟
  def parse_name_method_object_id(object_name,objects,value,default=1)
    id = nil
    if value =~ /^[0-9]+$/
      id = value.to_i
    else
      o = objects.find {|_o| (not _o.nil?) and _o.name == value}
      id = o.id unless o.nil?
    end
    if id.nil?
      # TODO G[
      Log.error("#{object_name}擾G[F#{value.tosjis}")
    id = default
    end
    return id
  end

  # RCxg̃p[X
  def parse_common_event_id(value)
    return parse_name_method_object_id("RCxg",Data_Loader.data_common_events,value.toutf8)
  end
  def common_event_name(id)
    return Data_Loader.data_common_events[id].name.tosjis
  end

  # Gl~[hc̃p[X
  def parse_enemy_id(value)
    actor_id = 1
    if value =~ /Gl~[\[(.+?)]/
      actor_id = parse_name_method_object_id("Gl~[",Data_Loader.data_enemies,$1)
    elsif value =~ /\[(.+?)\]/
      actor_id = parse_name_method_object_id("Gl~[",Data_Loader.data_enemies,$1)
    else
      actor_id = parse_name_method_object_id("Gl~[",Data_Loader.data_enemies,value)
    end
    return actor_id
  end

  # AN^[hc̃p[X
  def actor_id(value)
    parse_actor_id(value)
  end
  def parse_actor_id(value)
    actor_id = 1
    if value =~ /#{Regexp.escape('AN^[')}\[(.+?)\]/
      actor_id = parse_name_method_object_id("AN^[",Data_Loader.data_actors,$1.toutf8)
    elsif value =~ /\[(.+?)\]/
      actor_id = parse_name_method_object_id("AN^[",Data_Loader.data_actors,$1.toutf8)
    else
      actor_id = parse_name_method_object_id("AN^[",Data_Loader.data_actors,value)
    end
    return actor_id
  end
  def actor_name(id)
    return Data_Loader.data_actors[id].name.tosjis
  end

  # XL̃p[X
  def skill_id(value)
    return parse_name_method_object_id("XL",Data_Loader.data_skills,value.toutf8)
  end
  def parse_skill_id(value)
    return parse_name_method_object_id("XL",Data_Loader.data_skills,value.toutf8)
  end
  def skill_name(id)
    return Data_Loader.data_skills[id].name.tosjis
  end

  # ACẽp[X
  def item_id(value)
    return parse_name_method_object_id("ACe",Data_Loader.data_items,value.toutf8)
  end
  def parse_item_id(value)
    return parse_name_method_object_id("ACe",Data_Loader.data_items,value.toutf8)
  end
  def item_name(id)
    return Data_Loader.data_items[id].name.tosjis
  end

  # 
  def weapon_id(value)
    return parse_name_method_object_id("",Data_Loader.data_weapons,value.toutf8)
  end
  def parse_weapon_id(value)
    return parse_name_method_object_id("",Data_Loader.data_weapons,value.toutf8)
  end
  def weapon_name(id)
    return Data_Loader.data_weapons[id].name.tosjis
  end

  # h
  def armor_id(value)
    return parse_name_method_object_id("h",Data_Loader.data_armors,value.toutf8)
  end
  def parse_armor_id(value)
    return parse_name_method_object_id("h",Data_Loader.data_armors,value.toutf8)
  end
  def armor_name(id)
    return Data_Loader.data_armors[id].name.tosjis
  end

  # Xe[g
  def state_id(value)
    return parse_name_method_object_id("Xe[g",Data_Loader.data_states,value.toutf8)
  end
  def parse_state_id(value)
    return parse_name_method_object_id("Xe[g",Data_Loader.data_states,value.toutf8)
  end
  def state_name(id)
    return Data_Loader.data_states[id].name.tosjis
  end

  # Aj[V
  def animation_id(value)
    return parse_name_method_object_id("Aj[V",Data_Loader.data_animations,value.toutf8)
  end
  def animation_name(id)
    return Data_Loader.data_animations[id].name.tosjis
  end
  
  WEATHER_TYPES = ['','J','']

  # V
  def weather_type_id(value)
    return WEATHER_TYPES.index(value.tosjis)
  end
  def weather_type_name(id)
    WEATHER_TYPES[id]
  end

  # }bv
  def parse_map_id(value)
    id = nil
    if value =~ /^[0-9]+$/
      id = value.to_i
    else
      if value =~ /\[(.+?)\]/
      value = $1
      end
      Data_Loader.data_map_infos.each do |index,info|
        if info.name == value
          id = index
          break
        end
      end
    end
    if id.nil?
      # TODO G[
      Log.error("}bv擾G[F#{value}")
      id = 1
    end
    return id
  end
  def parse_map_name(id)
    return Data_Loader.data_map_infos[id].name
  end
  
end
